ORCA/M Asm65816 2.1.0

0001 0000                       eject 
0002 0000              *****************************************************************
0003 0000              *
0004 0000              * The following table is the header required for all loaded
0005 0000              * drivers which consists of the following:
0006 0000              *
0007 0000              *               Word    Offset from start to 1st DIB
0008 0000              *               Word    Number of DIBs
0009 0000              *               Word    Offset from start to 1st configuration list
0010 0000              *               Word    Offset from start to 2nd configuration list
0011 0000              *               etc.
0012 0000              *
0013 0000              *****************************************************************
0014 0000                       export driver_data
0015 0000              driver_data proc ENTRY
0016 0000                       export here
0017 0000              here                                    ;
0018 0000 60 00                 DC W:dib_1-here                ; offset to 1st DIB
0019 0002 08 00                 DC W:8                         ; number of devices
0020 0004 14 00                 DC W:conf1-here                ; offset to 1st configuration list
0021 0006 18 00                 DC W:conf2-here                ; offset to 2nd configuration list
0022 0008 1C 00                 DC W:conf3-here                ; offset to 3rd configuration list
0023 000A 20 00                 DC W:conf4-here                ; offset to 4th configuration list
0024 000C 1C 00                 DC W:conf3-here                ; offset to 5th configuration list
0025 000E 20 00                 DC W:conf4-here                ; offset to 6th configuration list
0026 0010 1C 00                 DC W:conf3-here                ; offset to 7th configuration list
0027 0012 20 00                 DC W:conf4-here                ; offset to 8th configuration list
0028 0014              *
0029 0014              * The following are the driver configuration parameter lists.
0030 0014              *
0031 0014                       export conf1
0032 0014 00 00        conf1    DC W:0                         ; 0 bytes in parameter list
0033 0016                       export default1
0034 0016 00 00        default1 DC W:0                         ; 0 bytes in default list
0035 0018
0036 0018                       export conf2
0037 0018 00 00        conf2    DC W:0                         ; 0 bytes in parameter list
0038 001A                       export default2
0039 001A 00 00        default2 DC W:0                         ; 0 bytes in default list
0040 001C
0041 001C                       export conf3
0042 001C 00 00        conf3    DC W:0
0043 001E                       export default3
0044 001E 00 00        default3 DC W:0
0045 0020
0046 0020                       export conf4
0047 0020 00 00        conf4    DC W:0
0048 0022                       export default4
0049 0022 00 00        default4 DC W:0
0050 0024
0051 0024                       eject 
0052 0024              *****************************************************************
0053 0024              *
0054 0024              * The following are tables of format options for each device.
0055 0024              * The format option tables have the following structure:
0056 0024              *
0057 0024              *               Word    Number of entries in list
0058 0024              *               Word    Display count (number of head links)
0059 0024              *               Word    Recommended default option
0060 0024              *               Word    Option that current online media is formatted with
0061 0024              *               Entries 16 bytes per entry in the format list
0062 0024              *
0063 0024              * The twenty byte structure for each entry in the format list
0064 0024              * is as follows:
0065 0024              *
0066 0024              *               Word    Media variables reference number
0067 0024              *               Word    Link to reference number n.
0068 0024              *               Word    Flags / Format environment
0069 0024              *               Long    Number of blocks supported by device
0070 0024              *               Word    Block size
0071 0024              *               Word    Interleave factor
0072 0024              *               Long    Number of bytes defined by flag
0073 0024              *
0074 0024              * Bit definition within the flags word is as follows:
0075 0024              *  ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___
0076 0024              * |   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |
0077 0024              * | F | E | D | C | B | A | 9 | 8 | 7 | 6 | 5 | 4 | 3 | 2 | 1 | 0 |
0078 0024              * |___|___|___|___|___|___|___|___|___|___|___|___|___|___|___|___|
0079 0024              *   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |___|__ Format
0080 0024              *   |   |   |   |   |   |   |   |   |   |   |   |   |___|__________ Flags
0081 0024              *   |___|___|___|___|___|___|___|___|___|___|___|__________________ Reserved
0082 0024              *
0083 0024              * Format Bit Definition: 00   Universal format
0084 0024              *                        01   Apple Format
0085 0024              *                        02   NonApple Format
0086 0024              *                        11   Not Valid
0087 0024              *
0088 0024              * Flag Bit Definition:   00   Size is in bytes
0089 0024              *                        01   Size is in Kb
0090 0024              *                        02   Size is in Mb
0091 0024              *                        11   Size is in Gb
0092 0024              *
0093 0024              *****************************************************************
0094 0024                       export format_tbl
0095 0024              format_tbl                              ;
0096 0024 28 00                 DC W:format1                   ; pointer to format option list #1
0097 0026 28 00                 DC W:format1                   ; pointer to format option list #2
0098 0028
0099 0028                       eject 
0100 0028                       export format1
0101 0028              format1                                 ;
0102 0028 02 00                 DC W:2                         ; number of entries
0103 002A 02 00                 DC W:2                         ; number of displayed entries
0104 002C 01 00                 DC W:1                         ; recommended option is 1
0105 002E 00 00                 DC W:0                         ; current media formatted w/option 1
0106 0030                       export format1_entry1
0107 0030              format1_entry1                          ;
0108 0030 01 00                 DC W:1                         ; RefNum
0109 0032 00 00                 DC W:0                         ; LinkRef
0110 0034 05 00                 DC W:4+1                       ; Apple format / size in kb
0111 0036 40 06 00 00           DC L:1600                      ; block count
0112 003A 00 02                 DC W:512                       ; block size
0113 003C 02 00                 DC W:2                         ; interleave factor
0114 003E 20 03                 DC W:800                       ; media size is 800kb
0115 0040                       export format1_entry2
0116 0040              format1_entry2                          ;
0117 0040 02 00                 DC W:2                         ; reference number 1
0118 0042 00 00                 DC W:0                         ; LinkRef
0119 0044 05 00                 DC W:4+1                       ; Apple format / size in kb
0120 0046 40 06 00 00           DC L:1600                      ; block count
0121 004A 00 02                 DC W:512                       ; block size
0122 004C 04 00                 DC W:4                         ; interleave factor
0123 004E 20 03                 DC W:800                       ; media size is 800kb
0124 0050
0125 0050                       export option_xlate
0126 0050              option_xlate                            ;
0127 0050 02 00                 DC W:2                         ; option 1 interleave
0128 0052 80 00                 DC W:128                       ; option 1 sides
0129 0054 04 00                 DC W:4                         ; option 2 interleave
0130 0056 80 00                 DC W:128                       ; option 2 sides
0131 0058 02 00                 DC W:2                         ; option 3 interleave
0132 005A 00 00                 DC W:0                         ; option 3 sides
0133 005C
0134 005C                       eject 
0135 005C              *****************************************************************
0136 005C              *
0137 005C              *               Link Pointer
0138 005C              *               entry Pointer
0139 005C              *               Device Characteristics
0140 005C              *  ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___
0141 005C              * |   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |
0142 005C              * | F | E | D | C | B | A | 9 | 8 | 7 | 6 | 5 | 4 | 3 | 2 | 1 | 0 |
0143 005C              * |___|___|___|___|___|___|___|___|___|___|___|___|___|___|___|___|
0144 005C              *   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |___|_ RESERVED
0145 005C              *   |   |   |   |   |   |   |   |   |   |   |   |   |   |_________ REMOVABLE
0146 005C              *   |   |   |   |   |   |   |   |   |   |   |   |   |_____________ FORMAT
0147 005C              *   |   |   |   |   |   |   |   |   |   |   |   |_________________ RESERVED
0148 005C              *   |   |   |   |   |   |   |   |   |   |   |_____________________ READ
0149 005C              *   |   |   |   |   |   |   |   |   |   |_________________________ WRITE
0150 005C              *   |   |   |   |   |   |   |   |   |_____________________________ BLOCK DEVICE
0151 005C              *   |   |   |   |   |   |   |___|_________________________________ SPEED GROUP
0152 005C              *   |   |   |   |   |   |_________________________________________ FIXED NAME
0153 005C              *   |   |   |   |   |_____________________________________________ RESTARTABLE
0154 005C              *   |   |   |   |_________________________________________________ BUSY
0155 005C              *   |   |   |_____________________________________________________ LINKED
0156 005C              *   |   |_________________________________________________________ GENERATED
0157 005C              *   |_____________________________________________________________ RAM/ROM DEV
0158 005C              *
0159 005C              *               Block Count
0160 005C              *               Device Name
0161 005C              *               Slot Number
0162 005C              *               Unit Number
0163 005C              *               Device ID Number
0164 005C              *               Head Device Link
0165 005C              *               Forward Device Link
0166 005C              *               Reserved Word
0167 005C              *               Reserved Word
0168 005C              *               DIB device number
0169 005C              *
0170 005C              *****************************************************************
0171 005C              * NOTE: dib's are used only in pairs 1&2, 3&4, 5&6, 7&8
0172 005C              * with one pair for each "slot" that has SmartPort Firmware
0173 005C              * each controller can have two AppleDisk drives 
0174 005C              *****************************************************************
0175 005C 00 00 00 00           DC L:0                         ;align dibs at 16 byte boundary for debugging
0176 0060                       export dib1acc_flag
0177 0060                       export dib3acc_flag
0178 0060                       export dib5acc_flag
0179 0060                       export dib7acc_flag
0180 0060                       export dib2acc_flag
0181 0060                       export dib4acc_flag
0182 0060                       export dib6acc_flag
0183 0060                       export dib8acc_flag
0184 0060
0185 0060                       export dib_1
0186 0060                       export dib1_slot
0187 0060              dib_1                                   ;
0188 0060 BA 00 02 00           DC L:dib_2                     ; link pointer to second DIB
0189 0064 E7 04 02 00           DC L:dispatch                  ; entry pointer
0190 0068 EC 0B                 DC W:$0BEC                     ; characteristics
0191 006A 00 00 00 00           DC L:00000000                  ; block count
0192 006E 0D                    DC B:13                        ; device name (length & 32 bytes ascii)
0193 006F 41 50 50 4C           DC B:'APPLEDISK3.5A                  '
0194 008E 00 00        dib1_slot DC W:$0000                    ; slot # (valid only after startup)
0195 0090 00 00                 DC W:$0000                     ; unit # (valid only after startup)
0196 0092 40 50                 DC W:current_version           ; version
0197 0094 00 00                 DC W:$0000                     ; device ID # (valid only after startup)
0198 0096 00 00                 DC W:$0000                     ; head device link
0199 0098 00 00                 DC W:$0000                     ; forward device link
0200 009A 42 03 02 00           DC L:stats_tbl                 ; Extended DIB pointer
0201 009E 00 00                 DC W:$0000                     ; dib device number
0202 00A0              *
0203 00A0              * The following data is an extension to the DIB required by the generated
0204 00A0              * driver core routines called the GENERATED DRIVER INFORMATION BLOCK (GDIB).
0205 00A0              *
0206 00A0 02 00                 DC W:$0002                     ; driver class
0207 00A2 01 00                 DC W:$0001                     ; SmartPort Type
0208 00A4 C0 00                 DC W:$00C0                     ; SmartPort Subtype
0209 00A6 FF FF                 DC W:$FFFF                     ; Cache Mask
0210 00A8 00 02                 DC W:512                       ; Device Block Size
0211 00AA 00 00                 DC W:$0000                     ; Device Hardware Unit Number(1/2)
0212 00AC 00 00        dib1acc_flag DC W:$0000                 ; External access detect flag
0213 00AE 00 00                 DC W:$0000                     ; Selected format option (if non zero)
0214 00B0 00 00                 DC W:$0000                     ; Last status result returned by driver
0215 00B2 00 00 00 00           DS W:4                         ; slot environ save temps
0216 00BA                       export dib_2
0217 00BA              dib_2                                   ;
0218 00BA 14 01 02 00           DC L:dib_3                     ; link pointer
0219 00BE E7 04 02 00           DC L:dispatch                  ; entry pointer
0220 00C2 EC 0B                 DC W:$0BEC                     ; characteristics
0221 00C4 00 00 00 00           DC L:00000000                  ; block count
0222 00C8 0D                    DC B:13                        ; device name (length & 32 bytes ascii)
0223 00C9 41 50 50 4C           DC B:'APPLEDISK3.5B                  '
0224 00E8 00 00                 DC W:$0000                     ; slot # (valid only after startup)
0225 00EA 00 00                 DC W:$0000                     ; unit # (valid only after startup)
0226 00EC 40 50                 DC W:current_version           ; version
0227 00EE 00 00                 DC W:$0000                     ; device ID # (valid only after startup)
0228 00F0 00 00                 DC W:$0000                     ; head device link
0229 00F2 00 00                 DC W:$0000                     ; forward device link
0230 00F4 42 03 02 00           DC L:stats_tbl                 ; Extended DIB pointer
0231 00F8 00 00                 DC W:$0000                     ; dib device number
0232 00FA              *
0233 00FA              * The following data is an extension to the DIB required by the generated
0234 00FA              * driver core routines called the GENERATED DRIVER INFORMATION BLOCK (GDIB).
0235 00FA              *
0236 00FA 02 00                 DC W:$0002                     ; driver class
0237 00FC 01 00                 DC W:$0001                     ; SmartPort Type
0238 00FE C0 00                 DC W:$00C0                     ; SmartPort Subtype
0239 0100 FF FF                 DC W:$FFFF                     ; Cache Mask
0240 0102 00 02                 DC W:512                       ; Device Block Size
0241 0104 00 00                 DC W:$0000                     ; Device Hardware Unit Number
0242 0106 00 00        dib2acc_flag DC W:$0000                 ; External access detect flag
0243 0108 00 00                 DC W:$0000                     ; Selected format option (if non zero)
0244 010A 00 00                 DC W:$0000                     ; Last status result returned by driver
0245 010C 00 00 00 00           DS W:4                         ; slot environ save temps
0246 0114
0247 0114                       export dib_3
0248 0114              dib_3                                   ;
0249 0114 6E 01 02 00           DC L:dib_4                     ; link pointer
0250 0118 E7 04 02 00           DC L:dispatch                  ; entry pointer
0251 011C EC 0B                 DC W:$0BEC                     ; characteristics
0252 011E 00 00 00 00           DC L:00000000                  ; block count
0253 0122 0D                    DC B:13                        ; device name (length & 32 bytes ascii)
0254 0123 41 50 50 4C           DC B:'APPLEDISK3.5C                  '
0255 0142 00 00                 DC W:$0000                     ; slot # (valid only after startup)
0256 0144 00 00                 DC W:$0000                     ; unit # (valid only after startup)
0257 0146 40 50                 DC W:current_version           ; version
0258 0148 00 00                 DC W:$0000                     ; device ID # (valid only after startup)
0259 014A 00 00                 DC W:$0000                     ; head device link
0260 014C 00 00                 DC W:$0000                     ; forward device link
0261 014E 42 03 02 00           DC L:stats_tbl                 ; Extended DIB pointer
0262 0152 00 00                 DC W:$0000                     ; dib device number
0263 0154              *
0264 0154              * The following data is an extension to the DIB required by the generated
0265 0154              * driver core routines called the GENERATED DRIVER INFORMATION BLOCK (GDIB).
0266 0154              *
0267 0154 02 00                 DC W:$0002                     ; driver class
0268 0156 01 00                 DC W:$0001                     ; SmartPort Type
0269 0158 C0 00                 DC W:$00C0                     ; SmartPort Subtype
0270 015A FF FF                 DC W:$FFFF                     ; Cache Mask
0271 015C 00 02                 DC W:512                       ; Device Block Size
0272 015E 00 00                 DC W:$0000                     ; Device Hardware Unit Number
0273 0160 00 00        dib3acc_flag DC W:$0000                 ; External access detect flag
0274 0162 00 00                 DC W:$0000                     ; Selected format option (if non zero)
0275 0164 00 00                 DC W:$0000                     ; Last status result returned by driver
0276 0166 00 00 00 00           DS W:4                         ; slot environ save temps
0277 016E
0278 016E                       export dib_4
0279 016E              dib_4                                   ;
0280 016E C8 01 02 00           DC L:dib_5                     ; link pointer
0281 0172 E7 04 02 00           DC L:dispatch                  ; entry pointer
0282 0176 EC 0B                 DC W:$0BEC                     ; characteristics
0283 0178 00 00 00 00           DC L:00000000                  ; block count
0284 017C 0D                    DC B:13                        ; device name (length & 32 bytes ascii)
0285 017D 41 50 50 4C           DC B:'APPLEDISK3.5D                  '
0286 019C 00 00                 DC W:$0000                     ; slot # (valid only after startup)
0287 019E 00 00                 DC W:$0000                     ; unit # (valid only after startup)
0288 01A0 40 50                 DC W:current_version           ; version
0289 01A2 00 00                 DC W:$0000                     ; device ID # (valid only after startup)
0290 01A4 00 00                 DC W:$0000                     ; head device link
0291 01A6 00 00                 DC W:$0000                     ; forward device link
0292 01A8 42 03 02 00           DC L:stats_tbl                 ; Extended DIB pointer
0293 01AC 00 00                 DC W:$0000                     ; dib device number
0294 01AE              *
0295 01AE              * The following data is an extension to the DIB required by the generated
0296 01AE              * driver core routines called the GENERATED DRIVER INFORMATION BLOCK (GDIB).
0297 01AE              *
0298 01AE 02 00                 DC W:$0002                     ; driver class
0299 01B0 01 00                 DC W:$0001                     ; SmartPort Type
0300 01B2 C0 00                 DC W:$00C0                     ; SmartPort Subtype
0301 01B4 FF FF                 DC W:$FFFF                     ; Cache Mask
0302 01B6 00 02                 DC W:512                       ; Device Block Size
0303 01B8 00 00                 DC W:$0000                     ; Device Hardware Unit Number
0304 01BA 00 00        dib4acc_flag DC W:$0000                 ; External access detect flag
0305 01BC 00 00                 DC W:$0000                     ; Selected format option (if non zero)
0306 01BE 00 00                 DC W:$0000                     ; Last status result returned by driver
0307 01C0 00 00 00 00           DS W:4                         ; slot environ save temps
0308 01C8
0309 01C8                       export dib_5
0310 01C8              dib_5                                   ;
0311 01C8 22 02 02 00           DC L:dib_6                     ; link pointer
0312 01CC E7 04 02 00           DC L:dispatch                  ; entry pointer
0313 01D0 EC 0B                 DC W:$0BEC                     ; characteristics
0314 01D2 00 00 00 00           DC L:00000000                  ; block count
0315 01D6 0D                    DC B:13                        ; device name (length & 32 bytes ascii)
0316 01D7 41 50 50 4C           DC B:'APPLEDISK3.5E                  '
0317 01F6 00 00                 DC W:$0000                     ; slot # (valid only after startup)
0318 01F8 00 00                 DC W:$0000                     ; unit # (valid only after startup)
0319 01FA 40 50                 DC W:current_version           ; version
0320 01FC 00 00                 DC W:$0000                     ; device ID # (valid only after startup)
0321 01FE 00 00                 DC W:$0000                     ; head device link
0322 0200 00 00                 DC W:$0000                     ; forward device link
0323 0202 42 03 02 00           DC L:stats_tbl                 ; Extended DIB pointer
0324 0206 00 00                 DC W:$0000                     ; dib device number
0325 0208              *
0326 0208              * The following data is an extension to the DIB required by the generated
0327 0208              * driver core routines called the GENERATED DRIVER INFORMATION BLOCK (GDIB).
0328 0208              *
0329 0208 02 00                 DC W:$0002                     ; driver class
0330 020A 01 00                 DC W:$0001                     ; SmartPort Type
0331 020C C0 00                 DC W:$00C0                     ; SmartPort Subtype
0332 020E FF FF                 DC W:$FFFF                     ; Cache Mask
0333 0210 00 02                 DC W:512                       ; Device Block Size
0334 0212 00 00                 DC W:$0000                     ; Device Hardware Unit Number
0335 0214 00 00        dib5acc_flag DC W:$0000                 ; External access detect flag
0336 0216 00 00                 DC W:$0000                     ; Selected format option (if non zero)
0337 0218 00 00                 DC W:$0000                     ; Last status result returned by driver
0338 021A 00 00 00 00           DS W:4                         ; slot environ save temps
0339 0222
0340 0222                       export dib_6
0341 0222              dib_6                                   ;
0342 0222 7C 02 02 00           DC L:dib_7                     ; link pointer
0343 0226 E7 04 02 00           DC L:dispatch                  ; entry pointer
0344 022A EC 0B                 DC W:$0BEC                     ; characteristics
0345 022C 00 00 00 00           DC L:00000000                  ; block count
0346 0230 0D                    DC B:13                        ; device name (length & 32 bytes ascii)
0347 0231 41 50 50 4C           DC B:'APPLEDISK3.5F                  '
0348 0250 00 00                 DC W:$0000                     ; slot # (valid only after startup)
0349 0252 00 00                 DC W:$0000                     ; unit # (valid only after startup)
0350 0254 40 50                 DC W:current_version           ; version
0351 0256 00 00                 DC W:$0000                     ; device ID # (valid only after startup)
0352 0258 00 00                 DC W:$0000                     ; head device link
0353 025A 00 00                 DC W:$0000                     ; forward device link
0354 025C 42 03 02 00           DC L:stats_tbl                 ; Extended DIB pointer
0355 0260 00 00                 DC W:$0000                     ; dib device number
0356 0262              *
0357 0262              * The following data is an extension to the DIB required by the generated
0358 0262              * driver core routines called the GENERATED DRIVER INFORMATION BLOCK (GDIB).
0359 0262              *
0360 0262 02 00                 DC W:$0002                     ; driver class
0361 0264 01 00                 DC W:$0001                     ; SmartPort Type
0362 0266 C0 00                 DC W:$00C0                     ; SmartPort Subtype
0363 0268 FF FF                 DC W:$FFFF                     ; Cache Mask
0364 026A 00 02                 DC W:512                       ; Device Block Size
0365 026C 00 00                 DC W:$0000                     ; Device Hardware Unit Number
0366 026E 00 00        dib6acc_flag DC W:$0000                 ; External access detect flag
0367 0270 00 00                 DC W:$0000                     ; Selected format option (if non zero)
0368 0272 00 00                 DC W:$0000                     ; Last status result returned by driver
0369 0274 00 00 00 00           DS W:4                         ; slot environ save temps
0370 027C
0371 027C                       export dib_7
0372 027C              dib_7                                   ;
0373 027C D6 02 02 00           DC L:dib_8                     ; link pointer
0374 0280 E7 04 02 00           DC L:dispatch                  ; entry pointer
0375 0284 EC 0B                 DC W:$0BEC                     ; characteristics
0376 0286 00 00 00 00           DC L:00000000                  ; block count
0377 028A 0D                    DC B:13                        ; device name (length & 32 bytes ascii)
0378 028B 41 50 50 4C           DC B:'APPLEDISK3.5G                  '
0379 02AA 00 00                 DC W:$0000                     ; slot # (valid only after startup)
0380 02AC 00 00                 DC W:$0000                     ; unit # (valid only after startup)
0381 02AE 40 50                 DC W:current_version           ; version
0382 02B0 00 00                 DC W:$0000                     ; device ID # (valid only after startup)
0383 02B2 00 00                 DC W:$0000                     ; head device link
0384 02B4 00 00                 DC W:$0000                     ; forward device link
0385 02B6 42 03 02 00           DC L:stats_tbl                 ; Extended DIB pointer
0386 02BA 00 00                 DC W:$0000                     ; dib device number
0387 02BC              *
0388 02BC              * The following data is an extension to the DIB required by the generated
0389 02BC              * driver core routines called the GENERATED DRIVER INFORMATION BLOCK (GDIB).
0390 02BC              *
0391 02BC 02 00                 DC W:$0002                     ; driver class
0392 02BE 01 00                 DC W:$0001                     ; SmartPort Type
0393 02C0 C0 00                 DC W:$00C0                     ; SmartPort Subtype
0394 02C2 FF FF                 DC W:$FFFF                     ; Cache Mask
0395 02C4 00 02                 DC W:512                       ; Device Block Size
0396 02C6 00 00                 DC W:$0000                     ; Device Hardware Unit Number
0397 02C8 00 00        dib7acc_flag DC W:$0000                 ; External access detect flag
0398 02CA 00 00                 DC W:$0000                     ; Selected format option (if non zero)
0399 02CC 00 00                 DC W:$0000                     ; Last status result returned by driver
0400 02CE 00 00 00 00           DS W:4                         ; slot environ save temps
0401 02D6
0402 02D6                       export dib_8
0403 02D6              dib_8                                   ;
0404 02D6 00 00 00 00           DC L:0                         ; link pointer
0405 02DA E7 04 02 00           DC L:dispatch                  ; entry pointer
0406 02DE EC 0B                 DC W:$0BEC                     ; characteristics
0407 02E0 00 00 00 00           DC L:00000000                  ; block count
0408 02E4 0D                    DC B:13                        ; device name (length & 32 bytes ascii)
0409 02E5 41 50 50 4C           DC B:'APPLEDISK3.5H                  '
0410 0304 00 00                 DC W:$0000                     ; slot # (valid only after startup)
0411 0306 00 00                 DC W:$0000                     ; unit # (valid only after startup)
0412 0308 40 50                 DC W:current_version           ; version
0413 030A 00 00                 DC W:$0000                     ; device ID # (valid only after startup)
0414 030C 00 00                 DC W:$0000                     ; head device link
0415 030E 00 00                 DC W:$0000                     ; forward device link
0416 0310 42 03 02 00           DC L:stats_tbl                 ; Extended DIB pointer
0417 0314 00 00                 DC W:$0000                     ; dib device number
0418 0316              *
0419 0316              * The following data is an extension to the DIB required by the generated
0420 0316              * driver core routines called the GENERATED DRIVER INFORMATION BLOCK (GDIB).
0421 0316              *
0422 0316 02 00                 DC W:$0002                     ; driver class
0423 0318 01 00                 DC W:$0001                     ; SmartPort Type
0424 031A C0 00                 DC W:$00C0                     ; SmartPort Subtype
0425 031C FF FF                 DC W:$FFFF                     ; Cache Mask
0426 031E 00 02                 DC W:512                       ; Device Block Size
0427 0320 00 00                 DC W:$0000                     ; Device Hardware Unit Number
0428 0322 00 00        dib8acc_flag DC W:$0000                 ; External access detect flag
0429 0324 00 00                 DC W:$0000                     ; Selected format option (if non zero)
0430 0326 00 00                 DC W:$0000                     ; Last status result returned by driver
0431 0328 00 00 00 00           DS W:4                         ; slot environ save temps
0432 0330
0433 0330                       eject 
0434 0330              *****************************************************************
0435 0330              *
0436 0330              * The following table is used to dispatch to GS/OS driver
0437 0330              * functions.
0438 0330              *
0439 0330              *****************************************************************
0440 0330                       export dispatch_table
0441 0330              dispatch_table                          ;
0442 0330 75 05                 DC W:startup-1
0443 0332 B9 08                 DC W:open-1
0444 0334 17 0D                 DC W:read-1
0445 0336 BE 08                 DC W:write-1
0446 0338 5D 09                 DC W:close-1
0447 033A 62 09                 DC W:status-1
0448 033C FC 0A                 DC W:control-1
0449 033E 3B 0C                 DC W:flush-1
0450 0340 40 0C                 DC W:shutdn-1
0451 0342
0452 0342                       export stats_tbl
0453 0342                       export Total_reads
0454 0342                       export Total_multiblk
0455 0342                       export Total_multifail
0456 0342                       export Total_multidisq
0457 0342              stats_tbl  
0458 0342 00 00 00 00  Total_reads DC L:0                      ;total calls to Read (BLOCK 512)
0459 0346 00 00 00 00  Total_multiblk DC L:0                   ;total calls of 5 or more blks per call
0460 034A 00 00 00 00  total_multidisq DC L:0                  ;total multiblk disqualified by caching/DSW
0461 034E 00 00 00 00  total_multifail DC L:0                  ;total multiblk reads that got errors
0462 0352
0463 0352                       eject 
0464 0352              *****************************************************************
0465 0352              *
0466 0352              * The following table contains the device status for each
0467 0352              * device supported by this driver.
0468 0352              *
0469 0352              * Encoding of status for a block device is as follows:
0470 0352              *  ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___
0471 0352              * |   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |
0472 0352              * | F | E | D | C | B | A | 9 | 8 | 7 | 6 | 5 | 4 | 3 | 2 | 1 | 0 |
0473 0352              * |___|___|___|___|___|___|___|___|___|___|___|___|___|___|___|___|
0474 0352              *   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |__ DISK SW
0475 0352              *   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |______ INTERRUPT
0476 0352              *   |   |   |   |   |   |   |   |   |   |   |   |   |   |__________ WRITE PROT
0477 0352              *   |   |   |   |   |   |   |   |   |   |   |   |   |______________ 0 RESERVED
0478 0352              *   |   |   |   |   |   |   |   |   |   |   |   |__________________ ONLINE
0479 0352              *   |___|___|___|___|___|___|___|___|___|___|______________________ 0 RESERVED
0480 0352              *
0481 0352              *****************************************************************
0482 0352
0483 0352                       eject 
0484 0352              *****************************************************************
0485 0352              *
0486 0352              * The following table is used to maintain the current head cylinder
0487 0352              * position for read's SEEK routine ; indexed by Drive # (0,1)
0488 0352              *
0489 0352              *****************************************************************
0490 0352                       export Cur_Cyl
0491 0352 FF           Cur_Cyl  DC B:$FF                       ; driv 1 Internal current head posn
0492 0353 FF                    DC B:$FF                       ; dirv 2 Internal current head posn
0493 0354
0494 0354              *****************************************************************
0495 0354              *
0496 0354              * The following table is used to maintain the current drive status
0497 0354              * status bits for dsw (b7), offline(b6), and motoron (b5).
0498 0354              *
0499 0354              *****************************************************************
0500 0354                       export drv_sts
0501 0354 00           Drv_Sts  DC B:$00                       ; driv 1 Internal status bits
0502 0355 00                    DC B:$00                       ; dirv 2 Internal status bits
0503 0356
0504 0356              *****************************************************************
0505 0356              *
0506 0356              * The following table is used to maintain a flag for detection 
0507 0356              * of non-driver "external" access to the SmartPort device.
0508 0356              * This table requires that the two drives have SmartPort unit #'s
0509 0356              * of 1 to 4
0510 0356              *
0511 0356              *****************************************************************
0512 0356                       export pre_check
0513 0356 00 00        pre_check DC W:0
0514 0358
0515 0358                       export bank1_lgth
0516 0358 66 03        bank1_lgth DC W:end_bank1-beg_bank1
0517 035A
0518 035A              *****************************************************************
0519 035A              * Used during Startup process to scan slots and drives 
0520 035A              *****************************************************************
0521 035A
0522 035A                       export device_count
0523 035A 00 00        device_count DC W:0                     ; number of devices started up
0524 035C
0525 035C                       export slot_units
0526 035C 00 00        slot_units DC W:0                       ; number of the units in this slot
0527 035E
0528 035E                       export slot_count
0529 035E 00 00        slot_count DC W:0                       ; number of SmartPort controllers Cards
0530 0360
0531 0360                       export last_slot
0532 0360 00 00        last_slot DC W:0                        ;has $5,$D,$F,$E,$C,$A,$9 during startup
0533 0362
0534 0362                       export last_drive
0535 0362 00 00        last_drive DC W:0                       ;has 1/2   0 means not known
0536 0364
0537 0364                       export name_char
0538 0364 20 41        name_char DC B:' A'                     ;driver name suffix character to "count"
0539 0366
0540 0366
0541 0366              *****************************************************************
0542 0366              *
0543 0366              * The following equates are general workspace used by the driver.
0544 0366              *
0545 0366              *****************************************************************
0546 0366                       export rom_version
0547 0366 00 00        rom_version DC W:0
0548 0368
0549 0368              * ext_slot set during all calls except Startup (which set it itself)
0550 0368                       export ext_slot
0551 0368 00 00        ext_slot DC W:0                         ;0 = internal, -1 = external
0552 036A
0553 036A
0554 036A                       export curnsect                ;sectors/cyl for current cyl
0555 036A                       export drive                   ;dib_hw_unit - 1 for current read
0556 036A                       export class                   ;speed group 
0557 036A                       export cyl                     ;input to Seek
0558 036A                       export track                   ;input to READTRK
0559 036A                       export sector                  ;output from BlkMap
0560 036A                       export side                    ;input to RDMODE, SetHead
0561 036A                       export msdelayctr              ;temp for MSWait routine
0562 036A                       export temp                    ;scratch for various
0563 036A                       export adrsret                 ;work for ReadTrk
0564 036A                       export seekret                 ;  "   
0565 036A                       export basepgbk                ;work for ReadTrk
0566 036A                       export basesave                ;save for ReadTrk
0567 036A                       export drswtch                 ;output from FastBuffr
0568 036A                       export irq_state               ;control for Seek enable of IRQ
0569 036A                       export prior_sts
0570 036A 00 00        prior_sts DC W:0                        ;prior contents of drv_sts,drive
0571 036C 00 00        irq_state DC W:0                        ;$00 = don't open for interrupts
0572 036E 00 00        drswtch  DC W:0                         ;$FF = fast buffer; $00 = slow memory
0573 0370 00 00        basesave DC W:0                         ;save for drvr_buf_ptr+1 & +2
0574 0372 00 00        basepgbk DC W:0                         ;base page+bank of current track buffer
0575 0374 00 00        seekret  DC W:0                         ;
0576 0376 00 00        adrsret  DC W:0                         ;
0577 0378 00 00        temp     DC W:0
0578 037A 00 00        msdelayctr DC W:0                       ;counter for # of milliseconds
0579 037C 00 00        side     DC W:0                         ;$00 = side 0; $80 = side 1
0580 037E 00 00        sector   DC W:0                         ; 
0581 0380 00 00        track    DC W:0                         ;0..159  (cyl with side bit as lsb)
0582 0382 00 00        cyl      DC W:0                         ;0..79
0583 0384 00 00        class    DC W:0                         ; = cyl div 16
0584 0386 00 00        drive    DC W:0                         ;dib_hw_unit - 1 (0 or 1)
0585 0388 00 00        curnsect DC W:0
0586 038A
0587 038A                       export sectinfo                ;output table of adrs field data
0588 038A                       export fmtfnd                  ; from the RdAddr routine
0589 038A                       export sidefnd
0590 038A                       export sectfnd
0591 038A                       export trkfnd
0592 038A                       export csfnd
0593 038A              ;  Sectinfo is really a table and must occur in order
0594 038A              sectinfo  
0595 038A 00           csfnd    DC B:0
0596 038B 00           fmtfnd   DC B:0
0597 038C 00           sidefnd  DC B:0
0598 038D 00           sectfnd  DC B:0
0599 038E 00           trkfnd   DC B:0
0600 038F              ;
0601 038F              ;--------------------------------------------
0602 038F              ;  Want-Found Table used by Track Read
0603 038F              ;      Value    Meaning
0604 038F              ;       $00     Sector Read sucessfully
0605 038F              ;       $40     Don't Want this sector
0606 038F              ;       $80     Read this sector (ASAP)
0607 038F              ;--------------------------------------------
0608 038F                       export want_fnd_tbl
0609 038F 00 00 00 00  want_fnd_tbl DS B:18
0610 03A1              ;----------------------------------------
0611 03A1              ; multi-track read input parmaeters
0612 03A1              ;----------------------------------------
0613 03A1                       export Cn00
0614 03A1                       export Slotx16
0615 03A1                       export SlotsReg
0616 03A1                       export Mu_cmdmode
0617 03A1                       export Mu_unitnum
0618 03A1                       export Mu_blk_num
0619 03A1                       export Mu_blk_cnt
0620 03A1                       export multi_err
0621 03A1                       export found_ctr
0622 03A1                       export read_ctr                ;input to ReadTrk
0623 03A1                       export begin_sect              ;input to ReadTrk
0624 03A1                       export tail_cnt                ;input to ReadTrk
0625 03A1                       export block_cnt               ;work for ReadTrk 
0626 03A1                       export block_ctr               ;input to ReadTrk
0627 03A1                       export trk_ctr                 ;input to ReadTrk
0628 03A1                       export end_blk_num
0629 03A1                       export end_sector
0630 03A1                       export end_track
0631 03A1                       export beg_blk_num
0632 03A1              beg_blk_num:  
0633 03A1 00 00        end_track DC W:0
0634 03A3 00 00        end_blk_num DC W:0
0635 03A5 00 00        block_ctr DC W:0                        ; input & counter for ReadTrk
0636 03A7 00 00        block_cnt DC W:0                        ; total number of blocks to read
0637 03A9 00 00        tail_cnt DC W:0                         ; number of sectors on last track
0638 03AB
0639 03AB 00 00        trk_ctr  DC W:0                         ;number of tracks (not cyls) to read (0..159)
0640 03AD 00 00        begin_sect DC W:0                       ; sector # of 1st sector on first track
0641 03AF 00 00        end_sector DC W:0
0642 03B1 00 00        read_ctr DC W:0                         ;count of number of sect to read on cur track
0643 03B3 00 00        found_ctr DC W:0
0644 03B5
0645 03B5              * The following overlay the above 10 bytes
0646 03B5              * Mu_cmdmode	dc.b	0
0647 03B5              * Mu_unitnum	dc.b	0
0648 03B5              *	dc.b	0
0649 03B5              * Mu_blk_num	dc.w	0
0650 03B5              *	dc.w	0
0651 03B5              * Mu_blk_cnt	dc.w	0
0652 03B5              *	dc.b	0
0653 03B5
0654 03B5 00 00        multi_err DC W:0                        ;temp to record Bad ending Block error
0655 03B7 00 00        Cn00     DC W:0                         ;gets $Cs00 
0656 03B9 00 00        Slotx16  DC W:0                         ;gets $00s0 
0657 03BB 00 00        SlotsReg DC W:0                         ;saves copy of sltromsel register ($C02D)
0658 03BD
0659 03BD              ;-----------------------------------
0660 03BD              ; GCR DATA TABLES FOR RDADDRs
0661 03BD              ;-----------------------------------
0662 03BD                       export DATAMARKS
0663 03BD                       export BSLIP1
0664 03BD                       export BSLIP2
0665 03BD                       export ADRMARKS
0666 03BD 96 AA D5     ADRMARKS DC B:$96,$AA,$D5
0667 03C0 AD AA D5     DATAMARKS DC B:$AD,$AA,$D5
0668 03C3 FF           BSMARKS  DC B:$FF
0669 03C4 AA           BSLIP2   DC B:$AA
0670 03C5 DE           BSLIP1   DC B:$DE
0671 03C6
0672 03C6                       eject 
0673 03C6              ****************************************************************
0674 03C6              *
0675 03C6              *       Following are the parameter lists used by the
0676 03C6              *       BANK $00 CORE DISPATCHER when calling a SmartPort
0677 03C6              *       interface.
0678 03C6              *
0679 03C6              ****************************************************************
0680 03C6              *
0681 03C6              * The following is the parameter list for a unit 0 status call
0682 03C6              * to the SmartPort.  This is used to determine the number of
0683 03C6              * devices logically connected to SmartPort.
0684 03C6              *
0685 03C6              *****************************************************************
0686 03C6                       export unit0_stat
0687 03C6 40           unit0_stat DC B:$40                     ; extended status call
0688 03C7 CB 03 02 00           DC L:unit0_plist               ; pointer to parameter list
0689 03CB 03           unit0_plist DC B:3                      ; parameter count
0690 03CC 00                    DC B:0                         ; unit number
0691 03CD D2 03 02 00           DC L:unit0_slist               ; pointer to status list
0692 03D1 00                    DC B:0                         ; status code
0693 03D2                       export unit0_slist
0694 03D2 00           unit0_slist DC B:0                      ; number of units
0695 03D3 00                    DC B:0                         ; interrupt status
0696 03D4 00                    DC B:0                         ; vendor ID
0697 03D5 00                    DC B:0                         ; reserved
0698 03D6 00 00 00 00           DC L:0                         ; native mode entry point
0699 03DA
0700 03DA              *****************************************************************
0701 03DA              *
0702 03DA              * The following is the parameter list for a unit N status call
0703 03DA              * to the SmartPort.  This is used to determine characteristics
0704 03DA              * of the SmartPort device.
0705 03DA              *
0706 03DA              *****************************************************************
0707 03DA                       export dib_stat
0708 03DA 40           dib_stat DC B:$40                       ; extended status call
0709 03DB DF 03 02 00           DC L:dib_plist                 ; pointer to parameter list
0710 03DF 03           dib_plist DC B:3                        ; parameter count
0711 03E0                       export dib_unit
0712 03E0 00           dib_unit DC B:0                         ; unit number
0713 03E1 E6 03 02 00           DC L:dib_slist                 ; pointer to status list
0714 03E5 03                    DC B:3                         ; status code
0715 03E6                       export dib_slist
0716 03E6                       export dib_blkcnt
0717 03E6 00           dib_slist DC B:0                        ; General status byte
0718 03E7 00 00 00 00  dib_blkcnt DC L:0                       ; Block count
0719 03EB 00                    DC B:0                         ; ID string length
0720 03EC 30 31 32 33           DC B:'0123'                    ; ID string
0721 03F0 34 35 36 37           DC B:'4567'
0722 03F4 38 39 41 42           DC B:'89AB'
0723 03F8 43 44 45 46           DC B:'CDEF'
0724 03FC                       export sp_type
0725 03FC 00           sp_type  DC B:0                         ; SmartPort Type
0726 03FD                       export sp_subtype
0727 03FD 00           sp_subtype DC B:0                       ; SmartPort Subtype
0728 03FE                       export sp_version
0729 03FE 00 00        sp_version DC W:0                       ; SmartPort Version
0730 0400
0731 0400              *****************************************************************
0732 0400              *
0733 0400              * The following parameter list is used to set the number of
0734 0400              * sides for the current online media in preperation for a
0735 0400              * subsequent format call.
0736 0400              *
0737 0400              *****************************************************************
0738 0400                       export set_sides
0739 0400 44           set_sides DC B:$44                      ; control call
0740 0401 05 04 02 00           DC L:sides_plist               ; parameter list pointer
0741 0405 03           sides_plist DC B:3                      ; parameter count
0742 0406                       export sides_unit
0743 0406 00           sides_unit DC B:0                       ; unit number
0744 0407 0C 04 02 00           DC L:sides_list                ; control list pointer
0745 040B 09                    DC B:$09                       ; control code
0746 040C 01 00        sides_list DC W:1                       ; count word
0747 040E                       export sides_cnt
0748 040E 00 00        sides_cnt DC W:0                        ; number of sides to set
0749 0410
0750 0410              *****************************************************************
0751 0410              *
0752 0410              * The following parameter list is used to set the interleave
0753 0410              * for the current online media in preperation for a subsequent
0754 0410              * format call.
0755 0410              *
0756 0410              *****************************************************************
0757 0410                       export set_intlv
0758 0410 44           set_intlv DC B:$44                      ; control call
0759 0411 15 04 02 00           DC L:ilv_plist                 ; parameter list pointer
0760 0415 03           ilv_plist DC B:3                        ; parameter count
0761 0416                       export ilv_unit
0762 0416 00           ilv_unit DC B:0                         ; unit number
0763 0417 1C 04 02 00           DC L:intlv_list                ; control list pointer
0764 041B 0A                    DC B:$0A                       ; control code
0765 041C 01 00        intlv_list DC W:1                       ; count word
0766 041E                       export intlv
0767 041E 02 00        intlv    DC W:2                         ; interleave value
0768 0420
0769 0420              *****************************************************************
0770 0420              *
0771 0420              * The following is the parameter list used to set the interleave
0772 0420              * to 4:1 on Shutdown.
0773 0420              *
0774 0420              *****************************************************************
0775 0420                       export clr_interleave
0776 0420                       export clr_intlv_unit
0777 0420 44           clr_interleave DC B:$44                 ; extended control call
0778 0421 25 04 02 00           DC L:@plist                    ; pointer to parameter list
0779 0425
0780 0425 03           @plist   DC B:3                         ; parameter count
0781 0426 00           clr_intlv_unit DC B:0                   ; unit number
0782 0427 2C 04 02 00           DC L:@list                     ; pointer to control list
0783 042B 0A                    DC B:$0A                       ; control code
0784 042C
0785 042C 01 00        @list    DC W:1                         ; count byte
0786 042E 04                    DC B:4                         ; interleave
0787 042F
0788 042F                       export set_fmt_option
0789 042F                       export set_fmt_unit
0790 042F                       export set_fmt_opt
0791 042F 4A           set_fmt_option DC B:$4A
0792 0430 34 04 02 00           DC L:@plist
0793 0434
0794 0434 03           @plist   DC B:3
0795 0435 00           set_fmt_unit DC B:0                     ;unit number
0796 0436 3C 04 02 00           DC L:@plist
0797 043A 02 00                 DC W:2
0798 043C              @plist    
0799 043C 00 00        set_fmt_opt DC W:0
0800 043E 00 00                 DC W:0
0801 0440
0802 0440              *****************************************************************
0803 0440              * The following is the parameter list used to read a block
0804 0440              *****************************************************************
0805 0440                       export blockread_list
0806 0440 41           blockread_list DC B:$41                 ; extended control call
0807 0441 45 04 02 00           DC L:blockrd_plist             ; pointer to parameter list
0808 0445 03           blockrd_plist DC B:3                    ; parameter count
0809 0446                       export blockrd_unit
0810 0446 00           blockrd_unit DC B:0                     ; unit number
0811 0447                       export blockrd_buf
0812 0447 00 00 00 00  blockrd_buf DC L:0                      ; pointer to buffer
0813 044B                       export blockrd_blk
0814 044B 00 00 00 00  blockrd_blk DC L:0                      ; block address
0815 044F
0816 044F              *****************************************************************
0817 044F              * The following is the parameter list used to write a block
0818 044F              *****************************************************************
0819 044F                       export blockwrite_list
0820 044F 42           blockwrite_list DC B:$42                ; extended control call
0821 0450 54 04 02 00           DC L:blockwr_plist             ; pointer to parameter list
0822 0454 03           blockwr_plist DC B:3                    ; parameter count
0823 0455                       export blockwr_unit
0824 0455 00           blockwr_unit DC B:0                     ; unit number
0825 0456                       export blockwr_buf
0826 0456 00 00 00 00  blockwr_buf DC L:0                      ; pointer to buffer
0827 045A                       export blockwr_blk
0828 045A 00 00 00 00  blockwr_blk DC L:0                      ; block address
0829 045E
0830 045E              *****************************************************************
0831 045E              * The following is the parameter list used to read a MAC block
0832 045E              *****************************************************************
0833 045E                       export readbyts_list
0834 045E                       export rdbyts_unit
0835 045E                       export rdbyts_buf
0836 045E                       export rdbyts_count
0837 045E                       export rdbyts_blk
0838 045E 48           readbyts_list DC B:$48                  ; extended readbytes call
0839 045F 63 04 02 00           DC L:rdbyts_plist              ; pointer to parameter list
0840 0463 04           rdbyts_plist DC B:4                     ; parameter count
0841 0464 00           rdbyts_unit DC B:0                      ; unit number
0842 0465 00 00 00 00  rdbyts_buf DC L:0                       ; pointer to buffer
0843 0469 00 00        rdbyts_count DC W:0                     ; count of bytes to read
0844 046B 00 00 00 00  rdbyts_blk DC L:0                       ; block address
0845 046F
0846 046F              *****************************************************************
0847 046F              * The following is the parameter list used to write a MAC block
0848 046F              *****************************************************************
0849 046F                       export writbyts_list
0850 046F                       export wrbyts_blk
0851 046F                       export wrbyts_buf
0852 046F                       export wrbyts_count
0853 046F                       export wrbyts_unit
0854 046F 49           writbyts_list DC B:$49                  ; extended writebytes call
0855 0470 74 04 02 00           DC L:wrbyts_plist              ; pointer to parameter list
0856 0474 04           wrbyts_plist DC B:4                     ; parameter count
0857 0475 00           wrbyts_unit DC B:0                      ; unit number
0858 0476 00 00 00 00  wrbyts_buf DC L:0                       ; pointer to buffer
0859 047A 00 00        wrbyts_count DC W:0                     ; count of bytes to read
0860 047C 00 00 00 00  wrbyts_blk DC L:0                       ; block address
0861 0480
0862 0480                       eject 
0863 0480              *****************************************************************
0864 0480              *
0865 0480              * The following is the parameter list used to set the hooks.
0866 0480              * Hook reference numbers are as follows:
0867 0480              *
0868 0480              *       $00     Main entry hook (not published)
0869 0480              *       $01     Read address field
0870 0480              *       $02     Read data field
0871 0480              *       $03     Write data field
0872 0480              *       $04     Seek
0873 0480              *       $05     Format disk
0874 0480              *       $06     Write track
0875 0480              *       $07     Verify track
0876 0480              *
0877 0480              *****************************************************************
0878 0480                       export sethook_list
0879 0480 44           sethook_list DC B:$44                   ; extended control call
0880 0481 85 04 02 00           DC L:sethook_plist             ; pointer to parameter list
0881 0485 03           sethook_plist DC B:3                    ; parameter count
0882 0486                       export sethook_unit
0883 0486 00           sethook_unit DC B:0                     ; unit number
0884 0487 8C 04 02 00           DC L:hook_list                 ; pointer to hook list
0885 048B 05                    DC B:5                         ; control code = set hook
0886 048C                       export hook_list
0887 048C 04 00        hook_list DC W:4                        ; count word
0888 048E                       export hook_ref
0889 048E 00           hook_ref DC B:0                         ; hook reference number
0890 048F                       export hook_addr
0891 048F 00 00 00 00  hook_addr DC L:0                        ; new hook address
0892 0493
0893 0493              *****************************************************************
0894 0493              *
0895 0493              * The following is the parameter list used to reset the hooks
0896 0493              *
0897 0493              *****************************************************************
0898 0493                       export resethook_list
0899 0493 44           resethook_list DC B:$44                 ; extended control call
0900 0494 98 04 02 00           DC L:resethook_plist           ; pointer to parameter list
0901 0498 03           resethook_plist DC B:3                  ; parameter count
0902 0499                       export resethook_unit
0903 0499 00           resethook_unit DC B:0                   ; unit number
0904 049A 9F 04 02 00           DC L:rsthook_list              ; pointer to hook list
0905 049E 06                    DC B:6                         ; control code = set hook
0906 049F                       export rsthook_list
0907 049F 04 00        rsthook_list DC W:4                     ; count word
0908 04A1                       export rsthook_ref
0909 04A1 00           rsthook_ref DC B:0                      ; hook reference number
0910 04A2
0911 04A2              **********************************************************************
0912 04A2              *
0913 04A2              * This parameter list is used to do a SetAdrs call to UCIC
0914 04A2              *
0915 04A2              **********************************************************************
0916 04A2                       export setAdrs_list
0917 04A2 44           setAdrs_list DC B:$44                   ; extended control call
0918 04A3 A7 04 02 00           DC L:@plist                    ; pointer to parameter list
0919 04A7 03           @plist   DC B:3                         ; parameter count
0920 04A8                       export setAdrs_unit
0921 04A8 00           setAdrs_unit DC B:0                     ; unit number
0922 04A9 AE 04 02 00           DC L:@data                     ; pointer to setAdrs list
0923 04AD 10                    DC B:16                        ; control code = set setAdrs
0924 04AE 02 00        @data    DC W:2                         ; count word
0925 04B0                       export setAdrs_addr
0926 04B0 00 00        setAdrs_addr DC W:0                     ; download/execute address
0927 04B2
0928 04B2              **********************************************************************
0929 04B2              *
0930 04B2              * This parameter list is used for the DownLoad call to UCIC
0931 04B2              *
0932 04B2              **********************************************************************
0933 04B2                       export dnLoad_list
0934 04B2 44           dnLoad_list DC B:$44                    ; extended control call
0935 04B3 B7 04 02 00           DC L:@plist                    ; pointer to parameter list
0936 04B7 03           @plist   DC B:3                         ; parameter count
0937 04B8                       export dnLoad_unit
0938 04B8 00           dnLoad_unit DC B:0                      ; unit number
0939 04B9 BE 04 02 00           DC L:@data                     ; pointer to dnLoad list
0940 04BD 11                    DC B:17                        ; control code = DownLoad
0941 04BE 07 00        @data    DC W:7                         ; byte word
0942 04C0                       longa off
0943 04C0 A9 FF                 lda   #$FF                     ;
0944 04C2                       export dibXflag_adrs
0945 04C2 8F AC 00 02  dibXflag_adrs sta   >dib1acc_flag
0946 04C6 60                    rts   
0947 04C7                       longa on
0948 04C7
0949 04C7              **********************************************************************
0950 04C7              *
0951 04C7              * This parameter list is used for the DownLoad call to UCIC when
0952 04C7              * nullifying the original DownLoad.
0953 04C7              *
0954 04C7              **********************************************************************
0955 04C7                       export dnLoad_list2
0956 04C7 44           dnLoad_list2 DC B:$44                   ; extended control call
0957 04C8 CC 04 02 00           DC L:@plist                    ; pointer to parameter list
0958 04CC 03           @plist   DC B:3                         ; parameter count
0959 04CD                       export dnLoad_unit2
0960 04CD 00           dnLoad_unit2 DC B:0                     ; unit number
0961 04CE D3 04 02 00           DC L:@data                     ; pointer to dnLoad list
0962 04D2 11                    DC B:17                        ; control code = DownLoad
0963 04D3 01 00        @data    DC W:1                         ; byte word
0964 04D5 60                    rts   
0965 04D6
0966 04D6              **********************************************************************
0967 04D6              *
0968 04D6              *       Read Disk Switch Status with phantom unit number status call
0969 04D6              *
0970 04D6              **********************************************************************
0971 04D6                       export dsw_stat
0972 04D6 40           dsw_stat DC B:$40                       ; extended status call
0973 04D7 DB 04 02 00           DC L:@plist                    ; pointer to parameter list
0974 04DB 03           @plist   DC B:3                         ; parameter count
0975 04DC                       export dsw_unit
0976 04DC 00           dsw_unit DC B:0                         ; unit number
0977 04DD E2 04 02 00           DC L:dsw_slist                 ; pointer to status list
0978 04E1 00                    DC B:0                         ; status code
0979 04E2                       export dsw_slist
0980 04E2 00           dsw_slist DC B:0                        ; General status byte
0981 04E3 00 00 00 00           DC L:0                         ; Block count
0982 04E7
0983 04E7
0984 04E7                       endp 
